#include <stdio.h>
#include <string.h>

typedef struct
{
	char ime[20];
	int id;
	int broj;
}Igrac;

int unosIgraca(char nazivFajla[], Igrac igraci[])
{
	int i = 0;
	
	FILE * fajl = fopen(nazivFajla, "r");
	
	while(!feof(fajl))
	{
		fscanf(fajl, "%s", igraci[i].ime);
		fscanf(fajl, "%d", &igraci[i].broj);
		
		igraci[i].id = i++;
		
	}
	
	fclose(fajl);
	
	return i;
}

void ispisIgraca(Igrac igraci[], int n, FILE * fajl)
{
	int i = 0;
	
	for( i = 0; i < n; i++)
	{
		fprintf(fajl, "id = %d, Ime = %s, broj = %d \n", igraci[i].id, igraci[i].ime, igraci[i].broj);		
	}
}

int izbaciNajmanji(Igrac igraci[], int n)
{
	int i, j;
	int najmanjiBroj = igraci[0].broj;
	
	for(i = 1; i < n; i++)
	{
		if(igraci[i].broj < najmanjiBroj)
			najmanjiBroj = igraci[i].broj;
	}
	
	for(i = 0; i < n; i++)
	{
		if(igraci[i].broj == najmanjiBroj)
		{
			for(j = i ; j < n - 1; j++)
				igraci[j] = igraci[j+1];
				
			n--;	
		}	
	}
	
	return n;
}

int formRunda(Igrac igraci[], int n, Igrac igraciNovaRunda[])
{
	int m = 0;
	int i, j;
	int daLiJeJedinstven;
	
	for( i = 0; i < n; i++)
	{
		daLiJeJedinstven = 1;
		
		for(j = 0; j < n; j++)
		{
			if(i != j && igraci[i].broj == igraci[j].broj)
			{
				daLiJeJedinstven = 0;
				break;		
			}
		}
		
		if(daLiJeJedinstven)
		{
			igraciNovaRunda[m] = igraci[i];
			m++;
		}
	}
	
	return m;
}

int najduzeIme(Igrac igraci[], int n)
{
	int id;
	int maksimalnaDuzina;
	int i;
	
	id = igraci[0].id;
	maksimalnaDuzina = strlen(igraci[0].ime);
	
	int duzina;
	for(i = 1; i < n; i++)
	{
		duzina = strlen(igraci[i].ime);
		if(duzina > maksimalnaDuzina)
		{
			maksimalnaDuzina = duzina;
			id = igraci[i].id;
		}	
	}
	
	return id;	
}

main()
{
	char nazivUlaznogFajlaSaIgracima[20];
	char nazivIzlaznogFajlaSaIgracima[20];
	Igrac igraci[50];
	Igrac igraciUNovojRundi[50];
	int brojIgraca, brojIgracaUNovojRundi;
	
	printf("Unesite naziv ulaznog fajla:\n");
	scanf("%s", nazivUlaznogFajlaSaIgracima);
	
	printf("Unesite naziv izlaznog fajla:\n");
	scanf("%s", nazivIzlaznogFajlaSaIgracima);
	
	FILE *f = fopen(nazivIzlaznogFajlaSaIgracima, "w");
	
	brojIgraca = unosIgraca(nazivUlaznogFajlaSaIgracima, igraci);

	int id = najduzeIme(igraci, brojIgraca);
	
	printf("\nId = %d, Ime = %s, broj = %d \n", igraci[id].id, igraci[id].ime, igraci[id].broj);		

	ispisIgraca(igraci, brojIgraca, f);

	fprintf(f, "\n----------------------------------\n");
	
	brojIgraca = izbaciNajmanji(igraci, brojIgraca);
	ispisIgraca(igraci, brojIgraca, f);
	
	fprintf(f, "\n----------------------------------\n");
	
	brojIgracaUNovojRundi = formRunda(igraci, brojIgraca, igraciUNovojRundi);
	ispisIgraca(igraciUNovojRundi, brojIgracaUNovojRundi, f);
	
	fclose(f);
		
}
